#include "StdAfx.h"
#include "SpeedDome.h"
#include "ControlDlg.h"
#include "math.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

//################################################################
// radar.cpp   for show the radar draw  
//
// RadarDraw(UINT start,UINT counter,float Pan,float Tilt)
//
//	UINT counter   |       0        |      1  
//	-----------------------------------------------
//	UINT start     |                | 
//          0      |       1        |       3  
//          1      |     2   0      |     2   0
//          2      |       3        |       1
//			3      |                |  
//
//   float Pan      :change Pie picture degree in 360            
//   (0~360 degree)   
//
//   float Tilt     :change Pie picture of radius 
//   (0~90 degree)  
//#################################################################

void CControlDlg::RadarDraw(UINT start,UINT counter,float Pan,float Tilt)
{   
CClientDC	dc(GetDlgItem(IDC_DRAW));	// dc is radar-frame in dialog box
CBrush		m_brush;					// Handle of null brush
BITMAP		m_bmInfo;					// Bitmap information structure 
CPoint		m_pt;						// Position for upper left corner 
CSize		m_size;						// Size (width and height) of bitmap
CRect		rectClient;					// radar-frame size
CBitmap*	radarBmap;
CDC			m_dcMem;					// Compatible memory DC for Radar show   
										// 1. draw in memory 
										// 2. paste to frame 
										// 3. Avoid Screen gilttering
//---------- Transform Pan and Tilt degree -----
int 	T_Int;

T_Int=(int) Pan/360;		Pan=Pan-T_Int*360;
T_Int=(int) Tilt/360;		Tilt=Tilt-T_Int*360;
if ( (Tilt>90)&&(Tilt<=180) )		Tilt=180-Tilt;
if ( (Tilt>180)&&(Tilt<=270) )		Tilt=Tilt-180;
if ( (Tilt>270)&&(Tilt<=360) )		Tilt=360-Tilt;
//----------------------------------------------
radarBmap=&(m_radBmap);					//-- get radar bitmap retrived from OnInitDialog
	
m_brush.CreateStockObject(NULL_BRUSH);	//Load null brush 
radarBmap->GetObject(sizeof(BITMAP),&m_bmInfo);
	
GetDlgItem(IDC_DRAW)->GetClientRect(&rectClient);	//-- Get frame coordinate
	m_size.cx=rectClient.right;						//-- Zero based coordinate
	m_size.cy=rectClient.bottom;
	m_pt.x=rectClient.left;
	m_pt.y=rectClient.top;

VERIFY(m_dcMem.CreateCompatibleDC(&dc));//---- Create memory DC using the radar-frame
m_dcMem.SelectObject(radarBmap);		//---- load radar-frame's bitmap to memory


//===================================================================
//  Below program are Drawing Speed Dome Position in memory  
//===================================================================
int		i;
float	pan;							// for Pan mod 360
CRect	rect;							// for radar pciture frame
double	xp1,yp1,xp2,yp2,xp3,yp3,xp4,yp4;	//for 45 degree index line
double	pi=3.1415926535;
  

pan= Pan-(int)Pan;						// get the decimal fraction  
Pan= (float)( (int)Pan  % 360)+pan;		// MOD 360 to avoid pan> 360
 
CFont   fontText;						// change the default font 
fontText.CreateFont(12,0,0,0,400,FALSE,FALSE,0,
                   ANSI_CHARSET,OUT_TT_PRECIS,
                   CLIP_DEFAULT_PRECIS,PROOF_QUALITY,
				   DEFAULT_PITCH|FF_SWISS,"Arial");
 
CFont* pOldFont  =( CFont*) m_dcMem.SelectObject(&fontText);

CString TiltDegree,PanDegree;			// change the number to string     
TiltDegree.Format("T%3.0f",Tilt);
PanDegree.Format("P%3.0f",Pan);

Pan=start*90+Pan;						//to draw Pie in different start value
  
double	x1,x2,y1,y2;					//for parameter of Pie  
UINT	cx,cy;							//center x and center y of radar picture
UINT	width,height,length,length2,length3,Position;
   
GetDlgItem(IDC_DRAW)->GetClientRect(rect);

//------ Change to different color pen and brush -------------   
CPen*     pen;
CBrush* brush;    
pen=new CPen(PS_SOLID,2,RGB(61,61,61)); 
brush=new CBrush(RGB(61,61,61)); 
	CBrush* oldBrush=m_dcMem.SelectObject(brush);
	CPen*   oldPen = m_dcMem.SelectObject(pen);
	m_dcMem.SelectObject(brush);
	m_dcMem.SelectObject(pen);
	width=rect.Width();
	height=rect.Height(); 
	m_dcMem.Ellipse(6,6,width-6,height-6);	//cover(dark-circle) the previous radar 
	m_dcMem.SelectObject(oldPen);
	m_dcMem.SelectObject(oldBrush);
delete pen;
delete brush;
//-----------------------------------------------------------
cx=rect.right/2;						// calculate the center point cx and cy
cy=rect.bottom/2;
      
length=(UINT) (height*Tilt*0.8/90/2);	// for the pie(light blue)
length3=(UINT)(height*0.79/2);			// for the pie(dark blue)

//---- Calculate para of Pie : x1,y1,x2,y2 for SpeedDome positon ----
switch(counter)
	{
	case 0: x1=cos( (double)(Pan+6)*pi/180)*height;
			y1=sin(-(double)(Pan+6)*pi/180)*height;
			x2=cos( (double)(Pan-6)*pi/180)*height;
			y2=sin(-(double)(Pan-6)*pi/180)*height;
			break;
	case 1:	x1=cos((double)(Pan+6)*pi/180)*height;
			y1=sin((double)(Pan+6)*pi/180)*height;
			x2=cos((double)(Pan-6)*pi/180)*height;
			y2=sin((double)(Pan-6)*pi/180)*height;
			break;
	}   
//-------------------------------------------------------------------

//----- calculate the 45 degree line coordinate
length2=(UINT)(height/2*0.8);
xp1=cos((double)( 45)*pi/180)*length2;	yp1=sin((double)( 45)*pi/180)*length2;
xp2=cos((double)(135)*pi/180)*length2;	yp2=sin((double)(135)*pi/180)*length2;
xp3=cos((double)(225)*pi/180)*length2;	yp3=sin((double)(225)*pi/180)*length2;
xp4=cos((double)(315)*pi/180)*length2;	yp4=sin((double)(315)*pi/180)*length2;
 
//---------- Draw 45 and 90 degree line ---------------
for(i=2;i>=1;i=i-1)
	{
	length2=(UINT)(height/2*i*0.5*0.8);
      
	pen=new CPen(PS_SOLID,1,RGB(90,160,245));
	brush=new CBrush(RGB(30,100,155));
	//-------------------------------------
	m_dcMem.SelectObject(brush);
	m_dcMem.SelectObject(pen);
	m_dcMem.Ellipse(cx-length2,cy-length2,cx+length2,cy+length2); 

	m_dcMem.MoveTo(cx,cy+length2-1);	m_dcMem.LineTo(cx,cy-length2);
	m_dcMem.MoveTo(cx+length2-1,cy);	m_dcMem.LineTo(cx-length2,cy);
  
	m_dcMem.MoveTo(cx+(int)xp1,cy+(int)yp1);	m_dcMem.LineTo(cx+(int)xp3,cy+(int)yp3); // "\"										
	m_dcMem.MoveTo(cx+(int)xp2,cy+(int)yp2);	m_dcMem.LineTo(cx+(int)xp4,cy+(int)yp4); // "/"	

	m_dcMem.SelectObject(oldPen);
	m_dcMem.SelectObject(oldBrush);
	//-------------------------------------
	delete pen;
	delete brush;
	}
//---------- End ----------------------------------------
m_dcMem.SetBkColor(RGB(30,100,155));
m_dcMem.SetTextColor(RGB(104,210,255));

//------- Show text on radar ----------------------------
if((cy+y1) <= cy)		//-- detect where to show the degree words
	{					//-- avoid cover the speed dome position
    m_dcMem.TextOut(0+29   ,cy+22,PanDegree);
    m_dcMem.TextOut(cx+3   ,cy+22,TiltDegree);
	}
else
	{
    m_dcMem.TextOut(0+29   ,cy-33,PanDegree);
    m_dcMem.TextOut(cx+3   ,cy-33,TiltDegree);
	}
//-------------------------------------------------------

//-- Draw the dark bule for pan degree : don't care the tilt Degree
//-- to avoid tilt degree=0 and don't know where the speed dome position    
pen  =new CPen(PS_SOLID,1,RGB(0,60,125));
brush=new CBrush(RGB(0,60,125));
	m_dcMem.SelectObject(brush);
	m_dcMem.SelectObject(pen);
	switch(counter)
		{
		case 0:	m_dcMem.Pie(cx-length3,cy-length3,cx+length3,cy+length3,cx+(int)x2,cy+(int)y2,cx+(int)x1,cy+(int)y1);
				break;
		case 1:	m_dcMem.Pie(cx-length3,cy-length3,cx+length3,cy+length3,cx+(int)x1,cy+(int)y1,cx+(int)x2,cy+(int)y2);
				break;
		}
	m_dcMem.SelectObject(oldPen);
	m_dcMem.SelectObject(oldBrush);
delete pen;
delete brush;
//------------------------------------------------------------------

//---- Draw the light bule for pan degree and care the tilt degree 
pen  =new CPen(PS_SOLID,1,RGB(104,210,255));
brush=new CBrush(RGB(104,210,255));  
	m_dcMem.SelectObject(brush);
	m_dcMem.SelectObject(pen);
	switch(counter)
		{
		case 0:	m_dcMem.Pie(cx-length,cy-length,cx+length,cy+length,
						cx+(int)x2,cy+(int)y2,cx+(int)x1,cy+(int)y1);
				break;
		case 1:	m_dcMem.Pie(cx-length,cy-length,cx+length,cy+length,
						cx+(int)x1,cy+(int)y1,cx+(int)x2,cy+(int)y2);
				break;
		}
	m_dcMem.SelectObject(oldBrush);
	m_dcMem.SelectObject(oldPen);
delete pen;
delete brush;
//-------------------------------------------------------------------  

pen=new CPen(PS_SOLID,1,RGB(90,160,245));
brush=new CBrush(RGB(90,160,245));
    
m_dcMem.SelectObject(brush);
m_dcMem.SelectObject(pen);

Position=(UINT)(height/2*0.8);
//-------- Draw a point (small disk) to show start position -----
if(counter==0)
	{
	switch(start)
		{
		case 0: m_dcMem.Ellipse(cx+Position-3,cy-3,cx+Position+3,cy+3);
				break;
		case 1:	m_dcMem.Ellipse(cx-3,cy-Position-3,cx+3,cy-Position+3);
				break;
		case 2:	m_dcMem.Ellipse(cx-Position-3,cy-3,cx-Position+3,cy+3);
				break;
		case 3:	m_dcMem.Ellipse(cx-3,cy+Position-3,cx+3,cy+Position+3);
				break;
		}
	}

if(counter==1)
	{
	switch(start)
		{
		case 0:	m_dcMem.Ellipse(cx+Position-3,cy-3,cx+Position+3,cy+3);
				break;
		case 1:	m_dcMem.Ellipse(cx-3,cy+Position-3,cx+3,cy+Position+3);
				break;
		case 2:	m_dcMem.Ellipse(cx-Position-3,cy-3,cx-Position+3,cy+3);
				break;
		case 3:	m_dcMem.Ellipse(cx-3,cy-Position-3,cx+3,cy-Position+3);
				break;
		}
	}  
  
m_dcMem.SelectObject(oldPen); //recovery the default
m_dcMem.SelectObject(oldBrush);
m_dcMem.SelectObject(pOldFont);
  
delete pen;
delete brush;
 
//---------- Paste radar picture form memory to radar-frame -------
dc.BitBlt(m_pt.x-1,m_pt.y-1,m_size.cx,m_size.cy,&m_dcMem,0,0,SRCCOPY);

DeleteDC(m_dcMem);

}


//##################################################################
//
//	Radar Back Panel
//
//##################################################################
void CControlDlg::RadarBackPanel()
{   
int			i;
double		pi=3.1415926535;
CClientDC	dc(GetDlgItem(IDC_DRAW));	// dc is radar-frame in dialog box
CBrush		m_brush;					// Handle of null brush
BITMAP		m_bmInfo;					// Bitmap information structure 
CPoint		m_pt;						// Position for upper left corner 
CSize		m_size;						// Size (width and height) of bitmap
CRect		rectClient;					// radar-frame size
CBitmap*	radarBmap;
CRect		rect;						// for radar pciture frame
double		xp1,yp1,xp2,yp2,xp3,yp3,xp4,yp4;	//for 45 degree index line
CDC			m_dcMem;					// Compatible memory DC for Radar show   
										// 1. draw in memory 
										// 2. paste to frame 
										// 3. Avoid Screen gilttering
radarBmap=&(m_radBmap);					//-- get radar bitmap retrived from OnInitDialog
	
m_brush.CreateStockObject(NULL_BRUSH);	//Load null brush 
radarBmap->GetObject(sizeof(BITMAP),&m_bmInfo);
	
GetDlgItem(IDC_DRAW)->GetClientRect(&rectClient);	//-- Get frame coordinate
	m_size.cx=rectClient.right;						//-- Zero based coordinate
	m_size.cy=rectClient.bottom;
	m_pt.x=rectClient.left;
	m_pt.y=rectClient.top;

VERIFY(m_dcMem.CreateCompatibleDC(&dc));//---- Create memory DC using the radar-frame
m_dcMem.SelectObject(radarBmap);		//---- load radar-frame's bitmap to memory

UINT	cx,cy;							//center x and center y of radar picture
UINT	width,height,length2,length3;
   
GetDlgItem(IDC_DRAW)->GetClientRect(rect);

//--------- Change to different color pen and brush -----------
CPen*		pen;  
CBrush*		brush;
pen=new CPen(PS_SOLID,2,RGB(61,61,61)); 
brush=new CBrush(RGB(61,61,61)); 
	CBrush* oldBrush=m_dcMem.SelectObject(brush);
	CPen*   oldPen = m_dcMem.SelectObject(pen);
	m_dcMem.SelectObject(brush);
	m_dcMem.SelectObject(pen);
	width=rect.Width();
	height=rect.Height(); 
	m_dcMem.Ellipse(6,6,width-6,height-6);	//cover(dark-circle) the previous radar 
	m_dcMem.SelectObject(oldPen);
	m_dcMem.SelectObject(oldBrush);
delete pen;
delete brush;
//--------------------------------------------------------------

cx=rect.right/2;						// calculate the center point cx and cy
cy=rect.bottom/2;
      
length3=(UINT)(height*0.79/2);			// for the pie(dark blue)
length2=(UINT)(height/2*0.8);

//----- calculate the 45 degree line coordinate
xp1=cos((double)( 45)*pi/180)*length2;	yp1=sin((double)( 45)*pi/180)*length2;
xp2=cos((double)(135)*pi/180)*length2;	yp2=sin((double)(135)*pi/180)*length2;
xp3=cos((double)(225)*pi/180)*length2;	yp3=sin((double)(225)*pi/180)*length2;
xp4=cos((double)(315)*pi/180)*length2;	yp4=sin((double)(315)*pi/180)*length2;
 
//---------- Draw 45 and 90 degree line ---------------------------
for(i=2;i>=1;i=i-1)
	{
	length2=(UINT)(height/2*i*0.5*0.8);
      
	pen=new CPen(PS_SOLID,1,RGB(90,160,245));
	brush=new CBrush(RGB(30,100,155));
	//-------------------------------------
	m_dcMem.SelectObject(brush);
	m_dcMem.SelectObject(pen);
	m_dcMem.Ellipse(cx-length2,cy-length2,cx+length2,cy+length2); 

	m_dcMem.MoveTo(cx,cy+length2-1);	m_dcMem.LineTo(cx,cy-length2);
	m_dcMem.MoveTo(cx+length2-1,cy);	m_dcMem.LineTo(cx-length2,cy);
  
	m_dcMem.MoveTo(cx+(int)xp1,cy+(int)yp1);	m_dcMem.LineTo(cx+(int)xp3,cy+(int)yp3); // "\"										
	m_dcMem.MoveTo(cx+(int)xp2,cy+(int)yp2);	m_dcMem.LineTo(cx+(int)xp4,cy+(int)yp4); // "/"	

	m_dcMem.SelectObject(oldPen);
	m_dcMem.SelectObject(oldBrush);
	//-------------------------------------
	delete pen;
	delete brush;
	}
//-----------------------------------------------------------------
m_dcMem.SetBkColor(RGB(30,100,155));
m_dcMem.SetTextColor(RGB(104,210,255));

//---------- Paste radar picture from memory to radar-frame -------
dc.BitBlt(m_pt.x-1,m_pt.y-1,m_size.cx,m_size.cy,&m_dcMem,0,0,SRCCOPY);

DeleteDC(m_dcMem);
   
}








